<?php
/**
 * MLPC License System - Yapılandırma Dosyası
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);

// Veritabanı Ayarları
define('DB_HOST', 'localhost');
define('DB_NAME', 'servlicence_license_db');
define('DB_USER', 'servlicence_license_db');
define('DB_PASS', 'Ch%m5S(^IIAo');
define('DB_CHARSET', 'utf8mb4');

// API Güvenlik Anahtarı (WordPress eklentisi bu anahtarı kullanır)
define('API_SECRET', 'mlpc-api-secret-2024-gizli');

// Desktop App için Admin Anahtarı (EXE bu anahtarı kullanır)
define('ADMIN_KEY', 'mlpc-admin-key-2024-gizli');

// CORS Ayarları
define('ALLOWED_ORIGINS', '*');

// Rate Limiting
define('RATE_LIMIT_MAX', 60);
define('RATE_LIMIT_WINDOW', 60);

// Timezone
date_default_timezone_set('Europe/Istanbul');

function getDB() {
    static $pdo = null;
    if ($pdo === null) {
        try {
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
            $pdo = new PDO($dsn, DB_USER, DB_PASS, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
            ]);
        } catch (PDOException $e) {
            sendError('Veritabanı bağlantı hatası', 500);
            exit;
        }
    }
    return $pdo;
}

function sendJSON($data, $code = 200) {
    http_response_code($code);
    header('Content-Type: application/json; charset=utf-8');
    header('Access-Control-Allow-Origin: ' . ALLOWED_ORIGINS);
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Authorization, X-API-Secret, X-Admin-Key');
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}

function sendError($message, $code = 400) {
    sendJSON(['success' => false, 'error' => $message], $code);
}

function sendSuccess($data = [], $message = 'İşlem başarılı') {
    sendJSON(array_merge(['success' => true, 'message' => $message], $data));
}

function normalizeDomain($domain) {
    $domain = strtolower(trim($domain));
    $domain = preg_replace('#^https?://#', '', $domain);
    $domain = preg_replace('#^www\.#', '', $domain);
    return rtrim($domain, '/');
}

function getClientIP() {
    foreach (['HTTP_X_FORWARDED_FOR', 'HTTP_X_REAL_IP', 'HTTP_CLIENT_IP', 'REMOTE_ADDR'] as $key) {
        if (!empty($_SERVER[$key])) return trim(explode(',', $_SERVER[$key])[0]);
    }
    return 'unknown';
}

function generateUUID() {
    return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff),
        mt_rand(0, 0x0fff) | 0x4000, mt_rand(0, 0x3fff) | 0x8000,
        mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff));
}
